 /*
 * SimpleReceiver.cpp
 *
 * Demonstrates receiving IR codes with IRremote
 *
 *  This file is part of Arduino-IRremote https://github.com/Arduino-IRremote/Arduino-IRremote.
 *
 ************************************************************************************
 * MIT License
 *
 * Copyright (c) 2020-2023 Armin Joachimsmeyer
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 ************************************************************************************
 */
/*
 @ Copyright Pierpaolo Martinello 16/08/2023
 */

/*
 * Specify which protocol(s) should be used for decoding.
 * If no protocol is defined, all protocols (except Bang&Olufsen) are active.
 * This must be done before the #include <IRremote.hpp>
 */
//#define DECODE_DENON        // Includes Sharp
//#define DECODE_JVC
//#define DECODE_KASEIKYO
//#define DECODE_PANASONIC    // alias for DECODE_KASEIKYO
//#define DECODE_LG
//#define DECODE_NEC          // Includes Apple and Onkyo
//#define DECODE_SAMSUNG
//#define DECODE_SONY
#define DECODE_RC5
//#define DECODE_RC6

//#define DECODE_BOSEWAVE
//#define DECODE_LEGO_PF
//#define DECODE_MAGIQUEST
//#define DECODE_WHYNTER
//#define DECODE_FAST

//#define DECODE_DISTANCE_WIDTH // Universal decoder for pulse distance width protocols
//#define DECODE_HASH         // special decoder for all protocols

//#define DECODE_BEO          // This protocol must always be enabled manually, i.e. it is NOT enabled if no protocol is defined. It prevents decoding of SONY!

//#define DEBUG               // Activate this for lots of lovely debug output from the decoders.

//#define RAW_BUFFER_LENGTH  180  // Default is 112 if DECODE_MAGIQUEST is enabled, otherwise 100.

#include <Arduino.h>
#include <Keyboard.h>   

/*
 * This include defines the actual pin number for pins like IR_RECEIVE_PIN, IR_SEND_PIN for many different boards and architectures
 */
#include "PinDefinitionsAndMore.h"
#include <IRremote.hpp> // include the library
#define LED_PIN   7

// #define _DBG_          // Se abilitato mostra sulla seriale tutti i messaggi dei codici ricevuti

int nact =  0 ;
String lbl[15] ;

void setup() {
    Serial.begin( 115200 );
    // Just to know which program is running on my Arduino
    // Serial.println(F("START " __FILE__ " from " __DATE__ "\r\nUsing library version " VERSION_IRREMOTE));

    // Start the receiver and if not 3. parameter specified, take LED_BUILTIN pin from the internal boards definition as default feedback LED
    IrReceiver.begin( IR_RECEIVE_PIN, ENABLE_LED_FEEDBACK ) ;

    Serial.print( F( "Ready to receive IR signals of protocols: " ) ) ;
    printActiveIRProtocols( &Serial ) ;
    Serial.println( F( "Ricezione sul Pin " STR(IR_RECEIVE_PIN) ) ) ;
    pinMode( LED_PIN, OUTPUT ) ;
}

void loop() {
    /*
     * Check if received data is available and if yes, try to decode it.
     * Decoded result is in the IrReceiver.decodedIRData structure.
     *
     * E.g. command is in IrReceiver.decodedIRData.command
     * address is in command is in IrReceiver.decodedIRData.address
     * and up to 32 bit raw data in IrReceiver.decodedIRData.decodedRawData
     */
    if ( IrReceiver.decode() ) {

        /*
         * Print a short summary of received data
         */
        #if defined( _DBG_ ) 
            IrReceiver.printIRResultShort( &Serial ) ; 

            IrReceiver.printIRSendUsage( &Serial ) ;
          
            if ( IrReceiver.decodedIRData.protocol == UNKNOWN ) {
                Serial.println( F( "Received noise or an unknown (or not yet enabled) protocol" ) );
                // We have an unknown protocol here, print more info
                IrReceiver.printIRResultRawFormatted( &Serial, true ) ;
            } 
        
        #endif

        /*
         * !!!Important!!! Enable receiving of the next value,
         * since receiving has stopped after the end of the current received data packet.
         */
        IrReceiver.resume() ; // Enable receiving of the next value

        /*
         * Finally, check the received data and perform actions according to the received command
         */
        if ( IrReceiver.decodedIRData.command ==0x20 ) {
            // "Pagina Su"
            GoTasto ( 0 , 1 , "Pagina Su" ) ;

        } else if ( IrReceiver.decodedIRData.command ==0x21 ) {
            // "Pagina giù"
            GoTasto ( 1 , 1, "Pagina Giù" ) ;

        } else if ( IrReceiver.decodedIRData.command ==0x50 ) {
            // "Freccia Su"
            GoTasto ( 0, 0, "Freccia Su" ) ;

        } else if ( IrReceiver.decodedIRData.command ==0x51 ) {
            // "Freccia Giù"
            GoTasto ( 1 , 0 , "Freccia Giù" ) ;
        }
    }
}
// Funzioni Tastiera
void GoTasto ( int act , int Pagina , String lbl ) {
     nact ++ ;
     if ( nact < 2 ) {       // Riduce i comandi doppi
       digitalWrite( LED_PIN , HIGH );
       switch ( act ) {
            case 0 :     // Indietro
                 switch ( Pagina ) {
                        case 0 :                // Opero come freccia indietro
                             Keyboard.press( KEY_UP_ARROW ) ;
                             break ;

                        case 1 :                // Opero come Pagina Su
                             Keyboard.press( KEY_PAGE_UP ) ;
                             break ;
                 }
                 break;

            case 1 :     // Avanti
                 switch ( Pagina ) {
                        case 0 :               // Opero come freccia avanti
                             Keyboard.press( KEY_DOWN_ARROW ) ;
                             break ;

                        case 1:                // Opero come Pagina Avanti
                             Keyboard.press(KEY_PAGE_DOWN) ;
                             break ;
                 }
                 break ;
     }

     delay( 100 ) ;
     // Sarebbe più indicato resettare il singolo comando dato ma così il codice è più compatto
     Keyboard.releaseAll() ;   // Resetta tutti i comandi tastiera
     delay( 120 ) ;  // Attendi prima di inviare un altro comando
     digitalWrite( LED_PIN , LOW ) ;
     Serial.print( F( "Ricevuto sul pin " STR(IR_RECEIVE_PIN) " il comando " ) ) ;
     Serial.println( lbl ) ;
     Serial.println( "" ) ;
     }
     if ( nact > 1 ) {  // in caso di doppio comando azzera il contatore
        nact = 0 ;
     }     
}